#include <stdio.h>
#include <stdlib.h>
void array3Dtest(int nx, int ny, int nz);
void array3DLineartest(int nx, int ny, int nz);
void array3DLinearOneIndextest(int nx, int ny, int nz);
int*** allocate3D(int l,int m,int n)
{
    int ***arr3D;
    int i,j;

    arr3D = (int***)malloc(l * sizeof(int **));

    for(i=0;i<l;i++)
    {
        arr3D[i] = (int**)malloc(m * sizeof(*arr3D[i]));
        for(j=0;j<m;j++)
        {
            arr3D[i][j] = (int*)malloc(n*sizeof(int));
        }
    }

    return arr3D;
}
void deallocate3D(int*** arr3D,int l,int m)
{
    int i,j;

    for(i=0;i<l;i++)
    {
        for(int j=0;j<m;j++)
        {
                free(arr3D[i][j]);
        }
        free(arr3D[i]);
    }
    free(arr3D);
}
void print3Darray(int ***arr3D,int nx,int ny,int nz)
{
    int i,j,k;
    //  print array elements
	for(i = 0; i < nx; i++)
	{
		for(j = 0; j < ny; j++)
		{
		for(k = 0; k < nz; k++)
			{
		        printf("array3D[%d][%d][%d]=%d\n",i,j,k,arr3D[i][j][k]);
            }
		}

	}
}
void main()
{
	//  Array 3 Dimensions
	int nx = 4, ny =5, nz =3;

	array3Dtest(nx,ny,nz);
	array3DLineartest(nx,ny,nz);
	array3DLinearOneIndextest(nx,ny,nz);

}
void array3Dtest(int nx, int ny, int nz)
{
	//  Array Iterators
	int i, j, k;
	//  Allocate 3D Array
	int ***array3D = allocate3D(nx,ny,nz);

	//  Access array elements
	for(i = 0; i < nx; i++)
	{


		for(j = 0; j < ny; j++)
		{


			for(k = 0; k < nz; k++)
			{
				array3D[i][j][k] = (i * ny * nz) + (j * nz) + k;
                printf("array3D[%d][%d][%d]=%d\n",i,j,k,array3D[i][j][k]);

			}
		}
	}
print3Darray(array3D,nx,ny,nz);
	//  Deallocate 3D array
	deallocate3D(array3D,nx,ny);
}
void array3DLineartest(int nx, int ny, int nz)
{
	//  Array Iterators
	int i, j, k;
	const int size0=nx*ny*nz;
	const int nyz0=ny * nz;
	int *array1D = calloc(size0,sizeof(int));


	//  Access array elements
		for(i = 0; i < nx; i++)
		{

		const int iSlice=(i * nyz0);


		for(j = 0; j < ny; j++)
		{
			 int jCol=(j * nz);
			 int rPtr=iSlice+j * nz;//jCol;
			for(k = 0; k < nz; k++)
			{
				const int index=iSlice + jCol + k;
				const int ind2=(i * ny * nz) + (j * nz) + k;
				const int ind3=rPtr+k;

					array1D[ind3]=(i * nyz0) + (j * nz) + k;
				//array1D[rPtr+k]=(i * nyz) + (j * nz) + k;
				//array1D[(i * nyz) + (j * nz) + k]=array1D[index];
				//array1D[ind3]=(i * nyz) + (j * nz) + k;
				printf("[%d][%d][%d]=%d\n",i,j,k,array1D[(i * ny * nz) + (j * nz) + k]);

			}
		}

		//puts();
	}

	free(array1D);
}
void array3DLinearOneIndextest(int nx, int ny, int nz)
{
	//  Array Iterators
	int i, j, k, index;
	const int size=nx*ny*nz;
int *array1D = calloc(size,sizeof(int));

	const int dept=ny * nz;

	//  Access array elements
int tmpind;

		for(index = 0; index < size; index++)
	{
		const int i=index/dept;
		//const int _nx=nx;
		const int _ny=ny;
		const int _nz=nz;
		const int iSlice=i*dept;
		const int jCol=index%(dept);
		const int j=jCol/_nz;
		const int rPtr=iSlice+j*_nz;
		const int k=jCol-j*_nz;
		const int tmpind=rPtr+k;

			array1D[tmpind]=(i * _ny * _nz) + (j * _nz) + k;

			// array1D[index];
			// array1D[rPtr+k];
	}

	free(array1D);
}
