#include <stdlib.h>
#include <GL/gl.h>
#include <GL/freeglut.h>
#include <iostream>
#include <assert.h>
#include <stdio.h>

class Point;
class Vector;
int winW=500,winH=500;
float d=200;

/***********************
 * Basic Point and Vector Classes
 * with some standard functions
 * Not complete.
 ************************/
class Point {
public:
  float x, y;

  Point(): x(0), y(0) { }
  Point(float _x, float _y) : x(_x), y(_y) { }
  static Point lerp(Point& p, Point& q, float t);
  static Point lerp(Point& p, Vector& q, float t);
};

class Vector {
public:
  float dx, dy;

  Vector() : dx(0), dy(0) { }
  Vector(Point& p, Point& q) {
    dx = q.x - p.x;
    dy = q.y - p.y;
  }

  // Returns the perp of the given Vector
  Vector perp() {
    Vector answer;
    answer.dx = -dy;
    answer.dy = dx;
    return answer;
  }
};

// Compute the Point that is a linear interpolation of p and q
Point Point::lerp(Point& p, Point& q, float t) {
  Point answer;
  answer.x = p.x + t*(q.x - p.x);
  answer.y = p.y + t*(q.y - p.y);
  return answer;
}

// Compute the Point that is a linear interpolation of p and v
Point Point::lerp(Point& p, Vector& v, float t) {
  Point answer;
  answer.x = p.x + t*v.dx;
  answer.y = p.y + t*v.dy;
  return answer;
}

/************************************************************
 * The rest of the code is not associated with a Class
 *   (not ideal but again, this illustrates GRAPHICS and
 *    NOT C++)
 ************************************************************/
void centerWorld(double cx, double cy, double sx, double sy);
void drawRay(Point start, Point end, int ticks = 0);
void drawCoordinateFrame();
void drawHouse();
void drawScene();
void display();

// Set the world to be centered at given location
//    With given size
void centerWorld(double cx, double cy, double sx, double sy) {
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(cx - sx/2, cx + sx/2, cy - sy/2, cy + sy/2);
}

// Draw a ray from start to end
//    Include arrow and tick marks
void drawRay(Point start, Point end, int ticks) {
  // First draw the line segment itself
  float step=0.0;
  if (ticks > 0) step = 1.0/ticks;
  glBegin(GL_LINES); {
    glVertex2f(start.x, start.y);
    glVertex2f(end.x, end.y);
  }
  glEnd();

  // Now draw the triangular arrow at the end
  Point r = Point::lerp(start, end, 1-step*0.7);  // 90% of way from start to end
  Vector n(start, end);
  Vector nperp = n.perp();
  Point r1 = Point::lerp(r, nperp, step/5);
  Point r2 = Point::lerp(r, nperp, -step/5);

    glBegin(GL_TRIANGLES); {
    glVertex2f(end.x, end.y);
    glVertex2f(r1.x, r1.y);
    glVertex2f(r2.x, r2.y);
  }

glEnd();

  if (ticks > 0) {
    // Draw tick marks
     float t;
    glPushMatrix();

    glBegin(GL_LINES); {
      for (t = 0; t <= 1.0; t += step) {
	Point r = Point::lerp(start, end, t);
	Point r1 = Point::lerp(r, nperp, step/5);
	Point r2 = Point::lerp(r, nperp, -step/5);
	glVertex2f(r1.x, r1.y);
	glVertex2f(r2.x, r2.y);
      }
    }
    glEnd();
    glPopMatrix();
  }
}

// Draw the x- and y- axes (use drawRay)
void drawCoordinateFrame() {
  Point origin(0, 0);
  Point xPoint(d/2.0, 0);
  Point yPoint(0, d/2.0);
  drawRay(origin, xPoint, 20);
  drawRay(origin, yPoint, 20);
}

// Draw a simple house
//   But wait it is just at the origin!
void drawHouse() {
  glBegin(GL_POLYGON); {
    glVertex2f(0, 0);
    glVertex2f(10, 0);
    glVertex2f(10, 10);
    glVertex2f(0, 10);
  }
  glEnd();
  glBegin(GL_TRIANGLES); {
    glVertex2f(-3, 10);
    glVertex2f(13, 10);
    glVertex2f(5, 15);
  }
  glEnd();
}

// Compute the Shear Matrix
//   OpenGL does not provide a Shear matrix
//   (that I could find yet)
//   Plus it illustrates how to pass ANYWAY
//   Matrix to OpenGL
//     Note: m goes down COLUMNS first...
//        m1, m2, m3, m4 represent m11, m21, m31, m41
//        m5, m6, m7, m8 represent m12, m22, m32, m42
//        etc...
void shearMatrix(int shearX, int shearY) {
  float m[] = {
    1, shearY, 0, 0,
      shearX, 1, 0, 0,
      0, 0, 1, 0,
      0, 0, 0, 1 };
  glMultMatrixf(m);
}

void printMatrix() {
  float m[16];
  glGetFloatv(GL_MODELVIEW_MATRIX, m);

  int row, col, index;
  for (row = 0; row < 4; row++) {
    for (col = 0, index = row; col < 4; col++, index+=4) {
      printf("%3.3f ", m[index]);
    }
    printf("\n");
  }
  printf("\n");
}
void drawScene2() {

  glLoadIdentity();
  printf("Identity\n");
  printMatrix();


  glColor3f(1, 0, 0);
  printf("Original House\n");
  drawCoordinateFrame();
  drawHouse();

glPushMatrix();
  glColor3f(0, 1, 0);
  glTranslated(20, 0, 0);
  printf("After Translating\n");
  printMatrix();

  drawCoordinateFrame(); drawHouse();

  glColor3f(0, 0, 1);
  glTranslated(20, 20, 0.0);
  printf("After  Translating Again...\n");
  printMatrix();

  drawCoordinateFrame(); drawHouse();


  glColor3f(0, 1, 1);
  glRotated(30, 0, 0, 1);  // 30 degrees about origin (z-axis)
   drawCoordinateFrame();
   drawHouse();
  glTranslated(60, 60, 0);
  glScaled(2, 0.5, 1);
  printf("After Rotate, Translate, Scale\n");
  printMatrix();

      glPushMatrix();
      glScaled(1.0/2.0,1.0/0.5,1);
      drawCoordinateFrame();
      glPopMatrix();
      glTranslated(0, 60, 0);
      //drawCoordinateFrame();
      drawHouse();

      glPopMatrix();
      glPushMatrix();
      glColor3f(1, 1, 1);
      glRotated(-30, 0, 0, 1);  // 30 degrees about origin (z-axis)
      glTranslated(20, 50, 0);
      glScaled(1.2, 0.5, 1);
      drawCoordinateFrame(); drawHouse();
      glPopMatrix();glPopMatrix();
glPopMatrix();
  glColor3f(0.5, 0.32, 0.1);
  glTranslated(50, 40, 0);
  shearMatrix(2, 3);


  drawCoordinateFrame(); drawHouse();
  printf("At the End\n");
  printMatrix();


}
void enableNiceDraw()
{
 glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);
 glHint(GL_POLYGON_SMOOTH_HINT,GL_NICEST);
 glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);

  glEnable(GL_POINT_SMOOTH);
  glEnable(GL_LINE_SMOOTH);
  glEnable(GL_POLYGON_SMOOTH);

}


void viewing(int W, int H)								//Window resize function, sets up viewing parameters (GLUT callback function)
{
	winW = W;
	winH = H;


	glViewport(0, 0, W, H);
	//
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	//for ortho uncomment
	const float V = (float)winW / winH;

	if (V >= 1) {
		// wide viewport, use full height
		glOrtho(-V*d/10 , V * d , -d/10 , d , -d , d );

	}
	else {
		// tall viewport, use full width
		glOrtho(- d/10,  d / 1, - d / 10/V,  d / 1/ V, -d / 1, d / 1);
		//ortho(-target_width / 2.0f, target_width / 2.0f, -A / V * target_height / 2.0f, A / V * target_height / 2.0f, ...);
	}


	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();



	glutPostRedisplay();




}
// Draw our complex scene!


void display() {
  // Set the viewport to the full screen!
  glViewport(0, 0, winW, winH);

  // Clear the screen
  glClearColor(0.2, 0.2, 0.2, 0.0);
  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(1.0,1.0,1.0);

  // Place origin in the center of our Frame
 // centerWorld(0, 0, 2*d, 2*d);
  // And now draw the scene

  drawScene2();

  glFlush();
  glutSwapBuffers();   // needed for double buffering!
}

void keyboard(unsigned char key, int x, int y)
{
  switch (key) {
  case 27:
  case 'Q':
  case 'q':
    exit(0);
    break;
  }

  // Redraw the screen on all keyboard events
  glutPostRedisplay();
}

int main(int argc, char** argv) {
  // Initialize the GLUT environment
  glutInit(&argc, argv);
  					//1. Initialize the GLUT toolkit
  glutSetOption(GLUT_MULTISAMPLE, 8);
  glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH|GLUT_MULTISAMPLE );
  glutInitWindowSize(winW,winH);
  glutCreateWindow("Transforms");
  glutReshapeFunc(viewing);
  // Set up the callback routines we will need/use
  enableNiceDraw();
  glutDisplayFunc(display);
  glutKeyboardFunc (keyboard);

  // Start GLUT going in its infinite event listen cycle
  glutMainLoop();
  return 0;
}
